define(['modules/appointments/booked/cancel-reasons-collection'], function(Collection) {
    'use strict';

    describe('Cancel Reasons', function() {
        var Model;

        beforeEach(function() {
            Model = Collection.prototype.model;
        });


        describe('Model', function() {
            it('parse data correctly', function() {
                var data = {number: 100, text: 'something'};
                var model = new Model(data, {parse: true});

                expect(model.get('number')).toEqual(data.number);
                expect(model.get('value')).toEqual(data.number);
                expect(model.id).toEqual(data.number);
                expect(model.get('text')).toEqual(data.text);
            });
        });

        describe('Collection', function() {
            it('parses data correctly', function() {
                var data = [
                    {number: 100, text: 'first'},
                    {number: 200, text: 'second'},
                ];

                var collection = new Collection({cancelReasonsList: data}, {parse: true});
                expect(collection.length).toBe(2);
                expect(collection.get(100).get('text')).toBe(data[0].text);
                expect(collection.get(200).get('text')).toBe(data[1].text);
            });
        });
    });
});
